bl_info = {
    "name": "fenutus Modifier Buttons",
    "author": "fenutus",
    "version": (1, 0),
    "blender": (3, 6, 0),
    "location": "Properties > Modifiers",
    "description": "Adds buttons for common modifiers below the menu.",
    "category": "Productivity"}

from bpy.types import Operator
import bpy, sys

class Master:
    bl_idname = "fenutus.modifiers_master"
    bl_label = "Modifier Buttons"
    bl_description = ""
    bl_context = "modifier"
    bl_options = {}

class QuickButton(Master, Operator):
    bl_idname = "fenutus.modifiers"
    bl_label = ""
    bl_description = "Add modifier"
    bl_options = {'REGISTER', 'UNDO'}
    modtype: bpy.props.StringProperty(name="modtype", default='MULTIRES')

    def execute(self, context):
        bpy.ops.object.modifier_add(type=getattr(self,"modtype"))
        return{'FINISHED'}
    
def DecorateDraw(func):
    def new_test(self, context):
        """decorator"""
    
        functions = [
            ('MULTIRES', 'MOD_MULTIRES', 'Multi Resolution'),
            ('SUBSURF', 'MOD_SUBSURF', "Subdiv Surface"),
            ('ARRAY', 'MOD_ARRAY', 'Array'),
            ('BEVEL', 'MOD_BEVEL', 'Bevel'),
            ('NODES', 'GEOMETRY_NODES', 'Geometry Nodes'),
            ('SOLIDIFY', 'MOD_SOLIDIFY', 'Solidify'),
            ('MIRROR', 'MOD_MIRROR', 'Mirror'),
            ('BOOLEAN', 'MOD_BOOLEAN', 'Boolean Cut'),
            ('DISPLACE', 'MOD_DISPLACE', 'Displace')
        ]
        
        num_col = 3

        layout = self.layout
        col = layout.column(align=True)
        #rw = col.row(align=True)
        
        i = 0
        while i < len(functions):
            rw = col.row(align=True)
            for c in range(num_col):
                function = functions[i]
                if i == len(functions):
                    continue
                op = rw.operator(QuickButton.bl_idname, text=function[2], icon=function[1])
                setattr(op,"modtype", function[0])
                i+=1
            
        func(self, context)

    return new_test


## ----------- REGISTER


def register():
    from bpy.utils import register_class
    import inspect
    
    thismodule = sys.modules[__name__]
    moddict = thismodule.__dict__
    
    clslist = [moddict[k] for k in moddict if inspect.isclass(moddict[k]) and inspect.getmodule(moddict[k]) == thismodule]

    blacklist = [Master,
                ]
            
    classes = [x for x in clslist if x not in blacklist]
    
    for cls in classes:
        bpy.app.handlers.save_post.append(cls)
        register_class(cls)
        
    clas = getattr(bpy.types, "DATA_PT_modifiers")
    clas.draw = DecorateDraw(clas.draw)

if __name__ == "__main__":
    register()